variable "token" {
    description = "The Linode API Personal Access Token."
}

variable "region" {
    description = "The region name for the Linode."
}

variable "node_count" {
    description = "The amount of backend Nodes to create."
    default = 1
}

variable "ssh_keys" {
    description = "The local file SSH key file for tranferring to each Linode instance."
}

variable "root_password" {
    description = "The root password for the server."
}

variable "jenkins_server_url" {
    description = "The URL or IP address, including port number, for the Jenkins server."
}

variable "jenkins_agent_secrets" {
    description = "The secret keys for each of the Jenkins agents."
}

variable storage_access_key {
    description = "The access key for the Linode Object Storage instance."
}

variable storage_secret_key {
    description = "The secret key for the Linode Object Storage instance."
}

variable storage_cluster {
    description = "The cluster for the Linode Object Storage instance."
}
