terraform {
    required_providers {
        linode = {
            source = "linode/linode"
        }
    }
}

provider "linode" {
    token = var.token
}

resource "linode_instance" "jenkins-agent-instances" {
    count = var.node_count
    image = "linode/ubuntu20.04"
    label = "jenkins-agent-instance-${count.index + 1}"
    group = "jenkins-servers"
    region = var.region
    type = "g6-standard-4"
    authorized_keys = var.ssh_keys
    root_pass = var.root_password

    connection {
        type = "ssh"
        user = "root"
        password = var.root_password
        host = self.ip_address
    }

    provisioner "file" {
        source = "scripts/initial_setup.sh"
        destination = "/tmp/initial_setup.sh"
    }

    provisioner "remote-exec" {
        inline = [
            # Add executable permission to the script, then execute it.
            "chmod +x /tmp/initial_setup.sh",
            "/tmp/initial_setup.sh ${var.jenkins_server_url} ${count.index + 1} ${var.jenkins_agent_secrets[count.index]} ${var.storage_access_key} ${var.storage_secret_key} ${var.storage_cluster}"
        ]
    }
}
